/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process;

import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import java.awt.SystemColor;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public abstract class VWDesignerBasePropertyPanel
extends JPanel {
    private static final int MAX_TAB_NAME_LENGTH = 18;
    protected VWAuthPropertyData m_authPropertyData = null;
    protected Vector m_controls = null;

    public VWDesignerBasePropertyPanel(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.m_controls = new Vector();
        this.createControls();
        this.setEnabled(false);
    }

    public void setEnabled(boolean bEnable) {
        super.setEnabled(bEnable);
        if (this.m_controls == null) {
            return;
        }
        for (int i = 0; i < this.m_controls.size(); ++i) {
            JComponent component = (JComponent)this.m_controls.elementAt(i);
            if (component == null) continue;
            if (component instanceof JTextArea) {
                JTextArea textArea = (JTextArea)component;
                textArea.setEditable(bEnable);
                if (bEnable) {
                    textArea.setBackground(SystemColor.text);
                    continue;
                }
                textArea.setBackground(this.getBackground());
                continue;
            }
            component.setEnabled(bEnable);
        }
    }

    public abstract Object getDataObject();

    public abstract void setDataObject(Object var1);

    public abstract String getDisplayName();

    public abstract String getToolTip();

    public abstract Icon getIcon();

    public abstract void displayHelpPage();

    public void releaseReferences() {
        if (this.m_controls != null) {
            this.m_controls.removeAllElements();
            this.m_controls = null;
        }
        this.m_authPropertyData = null;
        this.removeAll();
    }

    protected abstract void createControls();

    protected String getFormattedTabName(String name) {
        if (name != null && name.length() > 18) {
            return VWResource.s_ellipse.toString(name.substring(0, 18));
        }
        return name;
    }
}

